$fs=0.05;
epsilon=0.001;

thickness=2.0;
extra_keypad_clearance=0.3;

// The odd numbers are mil aligned positions in mm from the Kicad PCB

// Use projection fort DXF export
projection()
// rotation needed to put origin at upper left
rotate([180, 0, 0])
difference()
{
  translate([27.94, 38.1-14.2, 0])
    cube([147.32, 128.4, thickness]);

  translate([0,4.2,0])
  {
  // Display
  translate([36.83-2.54, 39.37-2.54, -epsilon])
    cube([138.43-36.83+2*2.54, 57.15-39.37+2*2.54, 2+2*epsilon]);
    
  // Keypad left
  translate([34.29-extra_keypad_clearance/2, 72.39-extra_keypad_clearance/2, -epsilon])
    cube([85.09-34.29+extra_keypad_clearance, 123.19-72.39+extra_keypad_clearance, 2+2*epsilon]);
    
  // Keypad right
  translate([95.25-extra_keypad_clearance/2, 72.39-extra_keypad_clearance/2, -epsilon])
    cube([120.65-95.25+extra_keypad_clearance, 123.19-72.39+extra_keypad_clearance, 2+2*epsilon]);

  // PCB mounting holes
  translate([31.75, 78.74, -epsilon])
    cylinder(h=2+2*epsilon, d1=6.0,d2=3.2);
  translate([90.17, 78.74, -epsilon])
    cylinder(h=2+2*epsilon, d1=6.0,d2=3.2);
  translate([124.46, 78.74, -epsilon])
    cylinder(h=2+2*epsilon, d1=6.0,d2=3.2);
  translate([31.75, 116.84, -epsilon])
    cylinder(h=2+2*epsilon, d1=6.0,d2=3.2);
  translate([90.17, 116.84, -epsilon])
    cylinder(h=2+2*epsilon, d1=6.0,d2=3.2);
  translate([124.46, 116.84, -epsilon])
    cylinder(h=2+2*epsilon, d1=6.0,d2=3.2);
  }

  // Frontplate mounting holes
  translate([27.94, 38.1-14.2, 0])
  {
    translate([7.45-5.9/2, 3-3.3/2, -epsilon])
      cube([5.9, 3.3, thickness+2*epsilon]);
    translate([7.45-5.9/2, 128.4-3-3.3/2, -epsilon])
      cube([5.9, 3.3, thickness+2*epsilon]);
    translate([147.32-7.45-5.9/2, 3-3.3/2, -epsilon])
      cube([5.9, 3.3, thickness+2*epsilon]);
    translate([147.32-7.45-5.9/2, 128.4-3-3.3/2, -epsilon])
      cube([5.9, 3.3, thickness+2*epsilon]);
  }
}
