// https://github.com/SebiTimeWaster/Chamfers-for-OpenSCAD/blob/master/Chamfer.scad
use <Chamfer.scad>;

$fs=0.05;

epsilon=0.001;

// Hole cover thickness
cover = 1;
// depth of label
text_depth = 0.5;
// 5*100 mil grid minus 0.25 mm tolerance
outside = 5*2.54-0.25;
// Switch is ~8.00 mm (uneven surface) plus tolerance
inside = 8.0+0.4;
// Measured 1.95 mm plus 0.2 mm tolerance
hole_x = 1.95+0.2;
// Measured 2.95 mm plus 0.2 mm tolerance
hole_y = 2.95+0.2;
// Measured 3 mm, no tolerance
hole_z = 3.0;
// Key height 8.0 mm minus tolerance 0.4 mm
key_height = 8.0-0.4;

module keycap(label)
{
  difference()
  {
    chamferCube(size=[outside,outside,key_height+hole_z+cover], chamfers=[[1, 1, 0, 0], [1, 0, 0, 1], [1, 1, 1, 1]], ch=1);
    //roundedcube(size=[outside,outside,key_height+hole_z+cover],center=false,radius=1.5,apply_to="zmin");
    translate([(outside-inside)/2,(outside-inside)/2,hole_z+cover])
      cube(size=[inside,inside,key_height+epsilon],center=false);
    translate([(outside-hole_x)/2,(outside-hole_y)/2,1])
      cube(size=[hole_x,hole_y,hole_z+epsilon],center=false);
    translate([outside/2,outside/2,-epsilon])
      linear_extrude(text_depth)
        mirror([1,0,0])  
          text(label,outside*0.6,valign="center",halign="center");
  }
}

if (false) {

translate([0*(outside+3),0*(outside+3),0]) keycap("0");
translate([1*(outside+3),0*(outside+3),0]) keycap("1");
translate([2*(outside+3),0*(outside+3),0]) keycap("2");
translate([3*(outside+3),0*(outside+3),0]) keycap("3");

translate([0*(outside+3),1*(outside+3),0]) keycap("4");
translate([1*(outside+3),1*(outside+3),0]) keycap("5");
translate([2*(outside+3),1*(outside+3),0]) keycap("6");
translate([3*(outside+3),1*(outside+3),0]) keycap("7");

translate([0*(outside+3),2*(outside+3),0]) keycap("8");
translate([1*(outside+3),2*(outside+3),0]) keycap("9");
translate([2*(outside+3),2*(outside+3),0]) keycap("A");
translate([3*(outside+3),2*(outside+3),0]) keycap("B");

translate([0*(outside+3),3*(outside+3),0]) keycap("C");
translate([1*(outside+3),3*(outside+3),0]) keycap("D");
translate([2*(outside+3),3*(outside+3),0]) keycap("E");
translate([3*(outside+3),3*(outside+3),0]) keycap("F");

}

translate([0*(outside+3),4*(outside+3),0]) keycap("\u2193");
translate([1*(outside+3),4*(outside+3),0]) keycap("\u2191");
translate([2*(outside+3),4*(outside+3),0]) keycap("T");
translate([3*(outside+3),4*(outside+3),0]) keycap("C");

translate([0*(outside+3),5*(outside+3),0]) keycap("S");
translate([1*(outside+3),5*(outside+3),0]) keycap("K");
translate([2*(outside+3),5*(outside+3),0]) keycap("R");
translate([3*(outside+3),5*(outside+3),0]) keycap("M");
