#!/usr/bin/env ruby

@id = 0

def write_verify(addr, data)
  a0 = addr & 1
  a1 = ( addr >> 1 ) & 1
  a2 = ( addr >> 2 ) & 1
  a3 = ( addr >> 3 ) & 1
  d0 = data & 1
  d1 = ( data >> 1 ) & 1
  d2 = ( data >> 2 ) & 1
  d3 = ( data >> 3 ) & 1
  q0 = (~d0) & 1
  q1 = (~d1) & 1
  q2 = (~d2) & 1
  q3 = (~d3) & 1

  puts "        <vector id=\"#{@id}\"> #{a0} 1 1 #{d0} Z #{d1} Z G Z #{d2} Z #{d3} #{a3} #{a2} #{a1} V </vector>"
  @id = @id + 1  
  puts "        <vector id=\"#{@id}\"> #{a0} 0 0 #{d0} Z #{d1} Z G Z #{d2} Z #{d3} #{a3} #{a2} #{a1} V </vector>"
  @id = @id + 1  
  puts "        <vector id=\"#{@id}\"> #{a0} 0 1 #{d0} #{q0} #{d1} #{q1} G #{q2} #{d2} #{q3} #{d3} #{a3} #{a2} #{a1} V </vector>"
  @id = @id + 1  
end

puts "      <ic name=\"74189\" type=\"5\" voltage=\"5V\" pins=\"16\">"

(0..15).each { |addr|

write_verify(addr,0)
write_verify(addr,15)
write_verify(addr,0)
write_verify(addr,15)

}

puts "      </ic>"
