; Test for UART2 transmitter at SOUT.
; Send repeatedly the pattern 0xa5 with 600 baud and 8N2 (2 MHz CPU clock).
; Idle is SOUT low and RS232 negative (mark)
; Start bit is SOUT high and RS232 positive (space)
;
; The Code origins from Elbug and must be run in RAM.
; Each value causes a delay of DLD (22T) and JNZ (9T) = 31T = 62 uS @ 2 MHz
; The resulting bit rate is always a little higher to compensate for loop
; overhead.
;
; Baud  speed  bit time [ms] @ 2 MHz
; 2400  0x02
; 1200  0x08
;  600  0x15   1.3
;  300  0x2e
;  110  0x85
;


low function n,n&0xff
high function n,n>>8

  nop
  ldi low(wspace)       ; setup p2 as working space pointer
  xpal p2
  ldi high(wspace)
  xpah p2

  ldi 0x15              ; speed 600 baud
  st speed(p2)

loop:
  ldi low(uart2putc-1)
  xpal p3
  ldi high(uart2putc-1)
  xpah p3
  ldi 0xa5
  xppc p3
  jmp loop

wspace:
bytesv equ 0
  db 0                  ; byte save for write
bitcnt equ 1
  db 0                  ; bit count for read and write
bitdly equ 2
  db 0                  ; bit delay for read write
speed equ 3
  db 0                  ; speed for data transfer
tmp equ 4
  db 0

uart2putc:
  st bytesv(p2)         ; save byte
  ldi 11                ; 1 startbit, 8 data, 2 stop bits
  st bitcnt(p2)         ; save bitcount
  ldi 0                 ; send startbit
  xae             
  sio                   ; shift out
  xae
  dld tmp(p2)           ; waste time
  ld bytesv(p2)         ; get byte
  xae                   ; into E
uart2putc1:
  ldi 11                ; delay
  dly 0
  ld speed(p2)          ; get bit speed
  st bitdly(p2)         ; stor into temp
uart2putc2:
  dld bitdly(p2)        ; wait
  jnz uart2putc2
  sio                   ; send out bit
  lde                   ; get data
  ori 0x80              ; set top bit (will be stop bit then)
  xae                   ; back into E
  dld bitcnt(p2)        ; decrement bit count
  jnz uart2putc1        ; not yet done, loop
  xppc p3               ; return from call
