; Original from "Mikrocomputer fuer den Selbstbau 1, Seite 92, Tabelle 6"
;
; The printing errors were fixed and absolute addresses replaced with
; labels.  The binary from ESS-002 is slightly different, because it
; was not saved after assembly or input, but after running it, which
; modifies the code.
;
; For 1 MHz SC/MP or 2 MHz SC/MP II

low function n,n&0xff
high function n,n>>8
  intsyntax -0oct,+0hex,+x'hex'

  org x'c00

begin:
  halt
  ldi x'01
  st count1a
  st count2
  ldi low(tab1)
  xpal p1
  ldi high(tab1)
  xpah p1
  ldi low(tab2)
  xpal p2
  ldi high(tab2)
  xpah p2
  ldi tab2-tab1+1       ; Anzahl der Toene plus 1
  st count3
a:
  ldi x'18
  dly x'00
b:
  ldi x'02
  cas
delay_h:
  ldi x'00
  dly x'00
  ldi x'00
  cas
delay_l:
  ldi x'00
  dly x'00
  dld count1a
  jnz a
  ld count1b
  st count1a
  dld count2
  jnz b
  nop
  dld count3
  jz begin
  ld @1(p1)
  st delay_l+1
  ccl
  adi x'32
  st delay_h+1
  ld @1(p2)
  st count1a
  st count1b
  ld @1(p2)
  st count2
  jmp b
count1a:
  db 0
count2:
  db 0
count3:                 ; Zahl der noch zu spielenden Toene
  db 0
count1b:
  db 0

; Frequenzen der Tonfolge
;
; f = 1e6 / (556 + 8 * byte)
;
; Ton  Hex.-Code  Frequenz
; A#   x'c7       466
; B    x'b8       494
; C    x'a9       523
; C#   x'9c       554
; D    x'8f       587
; D#   x'83       622
; E    x'78       659
; F    x'6d       698
; F#   x'63       740
; G    x'5a       784
; G#   x'51       831
; A    x'49       880
; A#   x'41       932
; B    x'39       988
; C    x'32       1047
; C#   x'2b       1109
; D    x'25       1175
; D#   x'1f       1245
; E    x'19       1319
; F    x'14       1397
; F#   x'0f       1480
; G    x'0a       1568
; G#   x'06       1661
; A    x'02       1760
;
tab1:
  db x'5a
  db x'49
  db x'5a
  db x'78
  db x'5a
  db x'49
  db x'5a
  db x'78
  db x'25
  db x'25
  db x'39
  db x'32
  db x'32
  db x'5A
  db x'49
  db x'49
  db x'32
  db x'39
  db x'49
  db x'5A
  db x'49
  db x'5A
  db x'78
  db x'49
  db x'49
  db x'32
  db x'39
  db x'49
  db x'5A
  db x'49
  db x'5A
  db x'78
  db x'25
  db x'25
  db x'14
  db x'25
  db x'39
  db x'32
  db x'19
  db x'32
  db x'5A
  db x'78
  db x'5A
  db x'6D
  db x'8F
  db x'A9

; Dauer der Toene
;
; t [s] = byte1 * byte2 * Periodendauer
;
tab2:
  db x'C4, x'03
  db x'DC, x'01
  db x'C4, x'02
  db x'C4, x'05
  db x'C4, x'03
  db x'DC, x'01
  db x'C4, x'02
  db x'C4, x'05
  db x'EB, x'05
  db x'C4, x'03
  db x'D6, x'07
  db x'83, x'08
  db x'57, x'06
  db x'EB, x'05
  db x'DC, x'04
  db x'DC, x'02
  db x'9D, x'05
  db x'F7, x'01
  db x'DC, x'02
  db x'C4, x'03
  db x'DC, x'01
  db x'C4, x'02
  db x'C4, x'05
  db x'DC, x'04
  db x'DC, x'02
  db x'9D, x'05
  db x'F7, x'01
  db x'DC, x'02
  db x'C4, x'03
  db x'DC, x'01
  db x'C4, x'02
  db x'C4, x'05
  db x'EB, x'05
  db x'C4, x'03
  db x'83, x'08
  db x'93, x'02
  db x'F7, x'02
  db x'9D, x'0A
  db x'F7, x'08
  db x'9D, x'05
  db x'C4, x'01
  db x'6E, x'03
  db x'C4, x'03
  db x'AF, x'01
  db x'93, x'02
  db x'6D, x'0C
