; Modified for 600 (SC/MP II 2 MHz) / 1200 (SC/MP II 4 MHz) baud.
; Echoing bug that sets the MSB is fixed.

	.TITLE KITBUG, 'P00937A 12/1/75'
;*****************************************************************
;*
;*
;*
;*	
;*
;*	
;*	
;*	
;*
;*
;*****************************************************************

P1	=	1
P2	=	2
P3	=	3
;
EXOFF	=	-1
	.PAGE	'STACK ASSIGNMENTS'
	.LOCAL
;
; FIXED	STACK ASSIGNMENTS
;
	.=0FFF
STACK:	
SR	=	.-STACK
	.=.-1
EX	=	.-STACK
	.=.-1
AC	=	.-STACK
	.=.-2
PT2	=	.-STACK
	.=.-2
PT1	=	.-STACK
	.=.-2
PC	=	.-STACK
;
P2ADR	=	.-1
	.PAGE	'DEBUG ENTRY AND EXIT'
	.LOCAL
;
; ON A SOFTWARE HALT, HARDWARE USES THE	FOLLOWING WORDS
; TO SAVE THE ENVIROMENT.
;
	.=0
	NOP	
START:	JMP	ENTER
;
; DEBUG	EXIT - RESTORE ENVIROMENT AND GO.
;
EXIT:	LD	STACK+EX	; RESTORE E REG
	XAE
	LD	STACK+PT1	; RESTORE P1
	XPAH	P1
	LD	STACK+PT1+1
	XPAL	P1
	LD	STACK+PT2	; RESTORE P2
	XPAH	P2
	LD	STACK+PT2+1
	XPAL	P2
	LD	STACK+PC	; PUT DESIRED PC IN P3
	XPAH	P3
	LD	STACK+PC+1
	XPAL	P3
	LD	@EXOFF(P3)	; ADD EXIT OFFSET TO PC
	LD	STACK+SR	; RESTORE SR
	CAS
	LD	STACK+AC
	XPPC	P3
;
; DEBUG	ENTRY POINT
;
ENTER:	ST	STACK+AC
	CSA
	ST	STACK+SR
	XAE			; SAVE EXTENSION REGISTER
	ST	STACK+EX
	XPAH	P2		;   POINTER
	ST	STACK+PT2
	XPAL	P2
	ST	STACK+PT2+1
	XPAH	P1		;   STACK	
	ST	STACK+PT1
	XPAL	P1
	ST	STACK+PT1+1
	XPAH	P3
	ST	STACK+PC
	XPAL	P3
	ST	STACK+PC+1
	.PAGE	'MAIN COMMAND LOOP'
	.LOCAL	
; THIS CODE INITIALIZES POINTER REGISTERS AND
; PROMPTS POR AND GETS THE NEXT COMMAND.
;
; ON EXIT, E HOLDS THE COMMAND CHARACTER
;
CMDLP:	LDI	L(P2ADR)	
	XPAL	P2
	LDI	H(P2ADR)
	XPAH	P2
	LDI	H(PUTC)		; PRINT CR-LF
	XPAH	P3
	LDI	L(PUTC)-1
	XPAL	P3
	LDI	0D
	XPPC	P3		; PRINT CR
	LDI	0A
	XPPC	P3		; PRINT LF
	LDI	'-'
	XPPC	P3	
	JS	P3,GECO		; GET COMMAND CHARACTER
	.PAGE	'GO'
	.LOCAL
;
; RESTORE MACHINE STATE AND TRANSFER CONTROL
; TO SPECIFIED ADDRESS.
;
; G ADDRESS
GO:	LDE
	XRI	'G'
	JNZ	$SKIP
	XPPC	P3		; CALL GECO
	XRI	0D
	JZ	EXIT
	JMP	ERROR
$SKIP:
	.PAGE	'TYPE'
	.LOCAL
;
; TYPE OR MODIFY MEMORY.
;
TYPE:	LDE			; CHECK FOR TYPE COMMAND, IF
	XRI	'T'		;   NOT 'T', SKIP COMMAND.
	JZ	$2
MOD:	LDE
	XRI	'M'
	JNZ	$SKIP
	LDI	0
	JMP	$1
$2:	LDI	1
$1:	ST	@-1(P2)		; SAVE FLAG FOR TYPE OR MODIFY
	JS	P3,GHEX		; GET ADDRESS	
	XRI	0D		; CHECK TERMINATOR
	JNZ	ERROR
	LD	@1(P2)		; PUT STARTING ADDRESS IN STACK
	XPAH	P1
	LD	@1(P2)
	XPAL	P1
$4:	LDI	H(PUTC)		; PRINT CR-LF
	XPAH	P3
	LDI	L(PUTC)-1
	XPAL	P3
	LDI	0D
	XPPC	P3		; PRINT CR
	LDI	0A
	XPPC	P3		; PRINT LF
	XPAH	P1		; PRINT	HIGH BYTE
	XAE			; READ AND RESTORE BYTE FROM P1
	LDE
	XPAH	P1
	LDI	H(PHEX2)
	XPAH	P3
	LDI	L(PHEX2)-1	
	XPAL	P3
	LDE
	XPPC	P3		; CALL PHEX2	
	XPAL	P1		; PRINT LOW BYTE
	XAE
	LDE
	XPAL	P1
	LDE
	XPPC	P3		; CALL PHEX1
	LD	@1(P1)
	XPPC	P3		; PRINT 2-DIGIT HEX FOLLOWED BY
				;   BLANK (PHEX1)
	LD	(P2)		; CHECK TYPE OR MODIFY FLAG
	JNZ	$4
	JS	P3,GECO
	XRI	0D
	JZ	$4	
	XRI	015		; 0D XOR 018 (CAN)	
LOOP1:	JZ	CMDLP
	JS	P3,GHEX2
	XRI	0D
	JNZ	ERROR
	LD	@1(P2)
	LD	@1(P2)
	ST	-1(P1)
	JMP	$4
$SKIP:
	.PAGE	'ERROR PROCESSING'	
	.LOCAL
;
; PRINT CARRAIGE RETURN , LINE FEED AND	LOOP
; TO THE TOP OF THE COMMAND LOOP.	
;
ERROR:	LDI	H(PUTC)		; PRINT	LINE FEED
	XPAH	P3
	LDI	L(PUTC)-1
	XPAL	P3
	LDI	0A
	XPPC	P3
	LDI	'?'
	XPPC	P3
	LDI	0
	JMP	LOOP1
	.PAGE	  'HEX NUMBER INPUT'
	.LOCAL
;
; GHEX GETS A 16-BIT VALUE AND PUSHES IT TO THE STACK.
; GHEX2 ASSUMES	THE FIRST CHAR IS IN THE E REGISTER.
; ONLY THE LAST	4 INPUT DIGITS ARE SAVED.
;
; RETURNS VALUE IN TOP 2 WORDS OF STACK AND TERMINATOR
; IN THE AC AND EX REGISTERS.
;
GHEX2:	LDI	1
	JMP	$6
GHEX:	LDI	0		; RESET GHEX2 FLAG
$6:	ST	-5(P2)
	LDI	L(GECO)-1	; SAVE RETURN ADDRESS AND SET UP
	XPAL	P3		;   TO GECO	
	ST	@-3(P2)		; STORE RETURN ADDRESS TO LEAVE ROOM
	LDI	H(GECO)		;   FOR RESULT
	XPAH	P3
	ST	@-1(P2)
	LD	-1(P2)
	JNZ	$1
	XPPC	P3
$1:	LDI	0		; INITIALIZE RESULT TO 0
	ST	3(P2)
	ST	2(P2)
$LOOP:	LDE
	SCL
	CAI	'9'+1		; CHECK FOR 0-9
	JP	$2		; NOT 0-9, TOO LARGE
	SCL
	CAI	'0'-'9'-1	; CHECK	FOR 0-9
	JP	$3		; IF POSITIVE, NUMBER IS
				;   IN RANGE AND CONVERTED.
$RET:	LD	@1(P2)		; NUMBER IS NOT A HEX DIGIT,
	XPAH	P3		;   RETURN
	LD	@1(P2)
	XPAL	P3
	LDE
	XPPC	P3
	JMP	GHEX
$2:	SCL
	CAI	'F'+1-'9'-1	; CHECK FOR DIGITS
	JP	$RET		; NUMBER TOO LARGE
	SCL
	CAI	'A'-'F'-1
	JP	$4		; DIGIT BETWEEN	A&F
	JMP	$RET
$4:	CCL
	ADI	10		; ADJUST DIGIT VALUE FOR 10-16
$3:	ST	-1(P2)		; SAVE ADJUSTED DIGIT	
	LDI	4		; SET UP BIT COUNTER FOR
	ST	-2(P2)		;  SHIFT.
$5:	CCL			; SHIFT HEX DIGIT LEFT ONE
	LD	3(P2)		;   DIGIT, ONE BIT EACH
	ADD	3(P2)		;  TIME THROUGH LOOP.
	ST	3(P2)
	LD	2(P2)
	ADD	2(P2)
	ST	2(P2)
	DLD	-2(P2)
	JNZ	$5
	CCL
	LD	3(P2)		; ADD CURRENT DIGIT INTO
	ADD	-1(P2)		;   NUMBER	
	ST	3(P2)
	XPPC	P3		; GET NEXT CHAR
	JMP	$LOOP		; AND LOOP
	.PAGE	'HEX NUMBER OUTPUT'
	.LOCAL
;
; PRINT HEX NUMBER WITH TRAILING BLANK (PHEX1) OR	
; WITHOUT IT (PHEX2).  NUMBER TO BE PRINTED IS
; IN AC.
;
PHEX1:	ST	@-1(P2)		; SAVE AC
	LDI	020		; SET FLAG TO PRINT BLANK AFTER
	JMP	$1		;   NUMBER
PHEX2:	ST	@-1(P2)		; SAVE AC	
	LDI	0		; CLEAR FLAG TO PRINT BLANK
$1:	ST	@-1(P2)		;   AFTER NUMBER
	LDI	L(PUTC)-1	; LOAD ADDRESS OF PUTC TO P3
	XPAL	P3		;   AND SAVE RETURN ADDRESS
	ST	@-1(P2)
	LDI	H(PUTC)
	XPAH	P3
	ST	@-1(P2)
	LDI	2		; SET FLAG FOR 1ST NUMBER
	ST	@-1(P2)
	LD	4(P2)		; GET ORIGINAL VALUE	
	SR			; SHIFT TO LOW 4 BITS
	SR
	SR
	SR
$5:	CCL			; CONVERT TO ASCII
	ADI	-10
	JP	$2		; NUMBER IS A THRU F
	ADI	'0'+10
	JMP	$3
$2:	ADI	'A'-1		; THE -1 TAKES CARE OF CARRY IN
$3:	XPPC	P3		; PRINT NUMBER	
	DLD	(P2)
	JZ	$4
	LD	4(P2)		; GET ORIGINAL NUMBER
	ANI	0F		; MASK 2ND DIGIT
	JMP	$5
$4:	LD	3(P2)		; CHECK POR PRINTING BLANK
	JZ	$6
	XPPC	P3		; IF NOT 0, PRINT BLANK
$6:	LD	1(P2)		; RESTORE RETURN ADDRESS
	XPAH	P3
	LD	2(P2)
	XPAL	P3
	LD	@4(P2)		; RESTORE STACK AND
	LD	@1(P2)
	XPPC	P3		; RETURN
	JMP	PHEX1
	.PAGE	'GECO'
	.LOCAL
;
; GECO IS USED FOR KEYBOARD INPUT SO IT ECHOS THE
; CHARACTER BUT DOES NOT ENABLE THE READER RELAY.
;
GECO:	LDI	8		; SET COUNT
	ST	-1(P2)
$2:	CSA			; WAIT FOR START BIT
	ANI	020
	JNZ	$2		; NOT FOUND
	LDI	0a7		; DELAY 1/2 BIT TIME
	DLY	0
	CSA			; IS START BIT STILL THERE?
	ANI	020
	JNZ	$2		; NO
	CSA			; SEND START BIT (NOTE THAT
	ORI	1		;   OUTPUT IS INVERTED)
	CAS
$LOOP:	LDI	045		; DELAY BIT TIME
	DLY	1
	CSA			; GET BIT (SENSEB)
	ANI	020
	JZ	$3
	LDI	1
$3:	ST	-2(P2)		; SAVE BIT VALUE (0 OR 1)
	RRL			; ROTATE INTO LINK
	XAE
	SRL			; SHIFT INTO CHARACTER
	XAE			; RETURN CHAR TO E
	CSA			; ECHO BIT TO OUTPUT
	ORI	1
	XOR	-2(P2)
	CAS	
	DLD	-1(P2)		; DECREMENT BIT COUNT
	JNZ	$LOOP		; LOOP UNTIL 0
	LDI	045		; DELAY BIT TIME FOR MSB
	DLY	1
	CSA			; SET STOP BIT
	ANI	0FE
	CAS
	DLY	4
	LDE			; AC HAS INPUT CHARACTER
	ANI	07F
	XAE
	LDE
	XPPC	P3		; RETURN	
	JMP	GECO
	.PAGE	'PUTC'
	.LOCAL
;
; PUT CHARACTER IN AC TO TTY. ALL REGS SAVED.
; IF INPUT DETECTED, CONTROL PASSES TO PROMPT.
; NOTE: TTY LOGIC LEVELS ARE INVERTED FOR OUTPUT
;
PUTC:	XAE
	LDI	025
	DLY	3
	CSA			; SET OUTPUT BIT TO LOGIC 0
	ORI 1			;   FOR START BIT. (NOTE INVERSION)
	CAS
	LDI	9		; INITIALIZE BIT COUNT
	ST	-1(P2)
$1:	LDI	050		; DELAY 1 BIT TIME
	DLY	1
	DLD	-1(P2)		; DECREMENT BIT COUNT.
	JZ	$EXIT
	LDE			; PREPARE NEXT BIT
	ANI	1
	ST	-2(P2)
	XAE			; SHIF DATA RIGHT 1 BIT
	SR
	XAE
	CSA			; SET UP OUTPUT BIT
	ORI	1
	XOR	-2(P2)
	CAS			; PUT BIT TO TTY
	JMP	$1
$EXIT:	CSA			; SET STOP BIT
	ANI	0FE
	CAS
	ANI	020		; CHECK FOR KEYBOARD INPUT
	JZ	$2		; ATTEMPTED INPUT (NOTE THAT
				;   INPUT IS NOT INVERTED)
	XPPC	P3		; RETURN	
	JMP	PUTC
$2:	JS	P3,CMDLP
	.END	
