// https://dkprojects.net/openscad-threads/
use <threads.scad>;
use <bolts.scad>;
include <parameters.scad>

camera_mount_width = 60;

module camera_mount_corners(width)
{
  translate([-width/2,-width/2,0]) children();
  translate([-width/2,+width/2,0]) children();
  translate([+width/2,-width/2,0]) children();
  translate([+width/2,+width/2,0]) children();
}

module camera_mount_body(width)
{
  hull() camera_mount_corners(width-10) cylinder(d=10,h=3,$fn=180);
}

module camera_mount_external(width)
{
  epsilon = 0.001;

  difference()
  {
    union()
    {
      camera_mount_body(width);
      translate([0,0,3])
        metric_thread(diameter=camera_mount_dia, pitch=0.75, length=4, internal=false, leadin=1);
    }

    /* light opening, for some reason more epsilon is needed */
    translate([0,0,-2*epsilon])
      cylinder(d=camera_mount_dia-4, h=7+4*epsilon, $fn=180);

    translate([0,0,3+epsilon])
      camera_mount_corners(width-10)
        m3_sunkhole(3+2*epsilon);
  }
}

module camera_mount_internal(width)
{
  epsilon = 0.001;
  depth = 5;

  camera_mount_body(width+0.1);
  // light opening
  translate([0,0,-depth+epsilon])
    cylinder(d1=camera_mount_dia-5, d2=camera_mount_dia-2*5, h=depth, $fn=180);
  camera_mount_corners(width-10)
    m3_corehole(15);
}

module camera_mount(internal=false)
{
  /* up to optical axis, rotate upright, outward 1 mm */
  translate([0,0,35]) rotate([-90,0,0]) translate([0,0,1])
  {
    if (internal)
      camera_mount_internal(camera_mount_width);
    else
      camera_mount_external(camera_mount_width);
  }
}

module camera_mount_backing_plate()
{
  epsilon = 0.001;

  translate([0,-3,35]) rotate([-90,0,0])
  {
    difference()
    {
      hull() camera_mount_corners(camera_mount_width) cylinder(d1=0,d2=6,h=3,$fn=180);

//      translate([0,0,-2*epsilon])
//        cylinder(d=camera_mount_width-6, h=3+4*epsilon);
    }
  }
}


camera_mount(internal=true);