use <slit_bracket.scad>
use <collimation.scad>
use <grating_bracket.scad>
use <camera_mount.scad>
use <case_shell.scad>
include <parameters.scad>

module case_base()
{
  lens_mount_base();
  at_lens_mount_end()
    grating_base();
}

module lower_slit_bracket_backing_plate()
{
  intersection()
  {
    slit_bracket_backing_plate();
    translate([-body_width/2,0,0]) cube([body_width,5,case_part_height]);
  }
}

module upper_slit_bracket_backing_plate()
{
  intersection()
  {
    slit_bracket_backing_plate();
    translate([-body_width/2,0,case_part_height]) cube([body_width,5,case_full_height-case_part_height]);
  }
}

module lower_camera_mount_backing_plate()
{
  intersection()
  {
    camera_mount_backing_plate();
    translate([-body_width/2,-5,0]) cube([body_width,5,case_part_height]);
  }
}

module upper_camera_mount_backing_plate()
{
  intersection()
  {
    camera_mount_backing_plate();
    translate([-body_width/2,-5,case_part_height]) cube([body_width,5,case_full_height-case_part_height]);
  }
}

module case_lower()
{
  mounts = [[-body_width/2+4,60,false],[body_width/2-4,60,false]];

  difference()
  {
    union()
    {
      case_shell(case_part_height,2,false,false,mounts) case_base();
      lower_slit_bracket_backing_plate();
      lens_mount();
      at_lens_mount_end()
      {
        grating_bracket();
        at_grating_base_camera_mount()
          lower_camera_mount_backing_plate();
      }
    }

    slit_bracket(internal=true);


    at_lens_mount_end()
      at_grating_base_camera_mount()
        camera_mount(internal=true);
  }
}

module case_upper()
{
  studs = [[-body_width/2+4,60,true],[body_width/2-4,60,true]];

  difference()
  {
    union()
    {
      translate([0,0,case_part_height])
        case_shell(case_full_height-case_part_height,2,true,true,studs) case_base();
      upper_slit_bracket_backing_plate();
      at_lens_mount_end()
      {
        at_grating_base_camera_mount()
          upper_camera_mount_backing_plate();
      }
    }

    slit_bracket(internal=true);

    at_lens_mount_end()
      at_grating_base_camera_mount()
        camera_mount(internal=true);
  }
}
