module case_shell_bolt_outer(height,wall,hole_dia,head_dia)
{
  cylinder(d=head_dia+2*wall, h=height, $fn=36);
}

module case_shell_bolt_inner(height,wall,hole_dia,head_dia)
{
  epsilon = 0.001;

  translate([0,0,-wall-epsilon])
  {
    reduction = head_dia-hole_dia;

    cylinder(d=hole_dia, h=height+wall+2*epsilon, $fn=36);
    cylinder(d=head_dia, h=height+wall+2*epsilon-reduction-1, $fn=36);
    // not great, but avoid need for support
    translate([0,0,height+wall+2*epsilon-reduction-1])
      cylinder(d1=head_dia, d2=hole_dia, h=reduction, $fn=36);
    // soft edge at bottom
    cylinder(d1=head_dia+wall/2, d2=head_dia, h=wall/2, $fn=36);
  }
}

module case_shell_stud_outer(height,wall,hole_dia)
{
  cylinder(d=hole_dia+2*wall, h=height, $fn=36);
}

module case_shell_stud_inner(height,hole_dia,hole_depth)
{
  epsilon = 0.001;

  translate([0,0,height-hole_depth+epsilon])
    cylinder(d=hole_dia, h=hole_depth, $fn=36);
}

module case_shell_wall(r1,r2)
{
  difference()
  {
    offset(r=r2, chamfer=true) children();
    offset(r=r1, chamfer=true) children();
  }
}

module case_shell_core(height,wall,outer_lip)
{
  /* walls */
  linear_extrude(height=height+(outer_lip?wall/2:-wall/2)) case_shell_wall(wall/2,wall) children();
  linear_extrude(height=height) case_shell_wall(0,wall/2) children();
  /* chamfered base */
  hull()
  {
    translate([0,0,-wall/2])
      linear_extrude(height=wall/2) offset(r=wall, chamfer=true) children();
    translate([0,0,-wall])
      linear_extrude(height=wall/2) offset(r=wall/2, chamfer=true) children();
  }
}

module case_shell_core_mounts(height,wall,outer_lip,upper,mounts)
{
  difference()
  {
  union()
  {
    case_shell_core(height,wall,outer_lip) children();

    // The stud parameters are for standard M3 thread inserts
    // The bolt parameters are for M3 screws

    if (len(mounts)>0) for (i=[0:len(mounts)-1])
    {
      translate([mounts[i][0],mounts[i][1],0])
      {
        if (mounts[i][2]) case_shell_stud_outer(height,wall+0.4,4.0);
        else case_shell_bolt_outer(height,wall,3.2,6.0);
      }
    }
  }

    if (len(mounts)>0) for (i=[0:len(mounts)-1])
    {
      translate([mounts[i][0],mounts[i][1],0])
      {
        if (mounts[i][2]) case_shell_stud_inner(height,4.0,5.7+3); // +3 for clearance
        else case_shell_bolt_inner(height,wall,3.2,6.0);
      }
    }
  }
}

module case_shell(height,wall,outer_lip,upper,mounts)
{
  if (upper)
  {
    translate([0,0,height])
      mirror([0,0,1])
        case_shell_core_mounts(height,wall,outer_lip,upper,mounts) children();
  }
  else
    case_shell_core_mounts(height,wall,outer_lip,upper,mounts) children();
}

case_shell(20,2,true,true,[[4,4]]) square([80,40]);
translate([0,60,0]) case_shell(20,2,false,false,[[4,4]]) square([80,40]);
translate([0,120,0])
{
  case_shell(20,2,false,false,[]) square([80,40]);
  translate([0,0,20+2])
    case_shell(10,2,true,true,[]) square([80,40]);
}

translate([0,200,0])
{
  difference()
  {
    case_shell_bolt_outer(20,2,3.2,5.5);
    case_shell_bolt_inner(20,2,3.2,5.5);
  }
}

translate([20,200,0])
{
  difference()
  {
    case_shell_stud_outer(20,2,4.9);
    case_shell_stud_inner(20,4.9,10);
  }
}
