use <bolts.scad>
use <threads.scad>
include <parameters.scad>

focus = 100; // distance between focus and front of lens bracket

/* Optical axis 35 mm over z 0
 */

module lens()
{
  cylinder(d1=27, d2=24, h=3.001, $fn=180);
  translate([0,0,3]) cylinder(d=25.3+0.1, h=10, $fn=180);
}

module lens_bracket()
{
  epsilon=0.001;

  translate([0,focus,35]) rotate([-90,0,0])
  {
    difference()
    {
      metric_thread(diameter=30, pitch=1, length=7, internal=false, leadin=2);

      translate([0,0,-epsilon]) lens();

      // slit for lens wrench
      translate([-20,0,-epsilon]) cube([40,1.5,1]);
    }
  }
}

module lens_focuser(internal=false)
{
  tolerance=0.2; // for easier thread movement
  epsilon=0.001;
  size=internal?35.2:35.0;

  translate([0,focus,35]) rotate([-90,0,0])
  {
    difference()
    {
      rotate([0,0,45]) translate([-size/2,-size/2]) cube([size,size,3]);

      if (!internal)
        translate([0,0,-epsilon]) metric_thread(diameter=30.0+tolerance, pitch=1, length=4, internal=true, leadin=2);
    }

    if (internal)
    {
      size2 = 35-2*2; // step of 2 mm
      rotate([0,0,45]) translate([-size2/2,-size2/2]) cube([size2,size2,5]);
    }
  }
}

module lens_mount()
{
  epsilon=0.001;

  difference()
  {
    translate([-(body_width-0.2)/2,focus,0]) cube([body_width-0.2,3,case_full_height-0.2]);

    translate([0,-1,0]) lens_focuser(internal=true);
  }
}

module lens_mount_base()
{
  // +12: +10 from mounting bracket +2 for adjustment
  translate([-body_width/2,0,0])
    square([body_width,focus+11]);
}

module at_lens_mount_end()
{
  translate([0,focus+11,0])
    children();
}

//rotate([-90,0,0]) lens_mount();
