/* #includes */ /*{{{C}}}*//*{{{*/
#include "config.h"

#include <errno.h>
#ifdef HAVE_GETTEXT
#include <libintl.h>
#define _(String) gettext(String)
#else
#define _(String) String
#endif
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "font.h"
#include "getopt.h"
#include "outputline.h"
/*}}}*/

int main(int argc, char *argv[])
{
  int usage=0,c,vertical=0;
  static struct option lopts[]=
  {
    { "font", required_argument, 0, 'f' },
    { "help", no_argument, 0, 'h' },
    { "vertical", no_argument, 0, 'v' },
    { "version", no_argument, 0, 'V' },
    { (const char*)0, 0, 0, '\0' }             
  };
  struct Font *cursive;
  struct OutputLine *line;
  const char *fontname="default";
  char *s;

  setlocale(LC_MESSAGES,"");
  setlocale(LC_CTYPE,"");
#ifdef HAVE_GETTEXT
  bindtextdomain("banner",LOCALEDIR);
  textdomain("banner");
#endif
  while ((c=getopt_long(argc,argv,"f:hvV",lopts,(int*)0))!=EOF) switch (c)
  {
    case 'f': fontname=optarg; break;
    case 'v': vertical=1; break;
    case 'V': printf("banner " VERSION "\n"); exit(0);
    case 'h': usage=2; break;
    default: usage=1; break;
  }
  if (usage==1)
  {
    fputs(_("Usage: banner [-v] [-f font] [text ...]\n"),stderr);
    fputs("\n",stderr);
    fputs(_("Try `banner -h' or `banner --help' for more information.\n"),stderr);	
    exit(1);
  }
  if (usage==2)
  {
    fputs(_("Usage: banner [-v] [-f font] [text ...]\n"),stdout);
    fputs("\n",stdout);  
    fputs(_("Print large banners.\n"),stdout);
    fputs("\n",stdout);
    fputs(_("-f, --font     use the specified font instead of the default font.\n"),stdout);
    fputs(_("-v, --vertical print banner vertically\n"),stdout);
    fputs(_("-h, --help     print this message\n"),stdout);
    fputs(_("    --version  print the version\n"),stdout);
    fputs("\n",stdout);
    fputs(_("Report bugs to <michael@moria.de>\n"),stdout);
    exit(0);
  }
  cursive=Font_new(fontname);
  line=OutputLine_new(cursive->scanLines);
  if (optind<argc)
  {
    for (; optind<argc; ++optind)
    {
      for (s=argv[optind]; *s; OutputLine_addChar(line,*s++,cursive));
      if (optind<(argc-1)) OutputLine_addChar(line,' ',cursive);
    }
  }
  else
  {
    while ((c=getchar())!=EOF)
    {
      if (c=='\n')
      {
        (vertical ? OutputLine_printLineVertical : OutputLine_printLineHorizontal)(line);
        OutputLine_erase(line);
      }
      else OutputLine_addChar(line,c,cursive);
    }
  }
  if (!OutputLine_isEmpty(line)) (vertical ? OutputLine_printLineVertical : OutputLine_printLineHorizontal)(line);
  return 0;
}
