/* #includes */ /*{{{C}}}*//*{{{*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE

#include "config.h"

#include <errno.h>
#ifdef HAVE_GETTEXT
#include <libintl.h>
#define _(String) gettext(String)
#else
#define _(String) String
#endif
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "font.h"
#include "misc.h"
/*}}}*/

struct Font *Font_new(const char *name) /*{{{*/
{
  struct Font *this;
  FILE *fp;
  int line,i,ch;
  char ln[128];
  struct FontCharacter **fch;
  char fontname[_POSIX_PATH_MAX];

  if ((this=malloc(sizeof(struct Font)))==(struct Font*)0)
  {
    fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),sizeof(struct Font),strerror(errno));
    exit(2);
  }
  for (i=0; i<256; ++i) this->character[i]=(struct FontCharacter*)0;
  strncpy(fontname,SHAREDIR "/banner/",sizeof(fontname));
  strncat(fontname,name,sizeof(fontname));
  if ((fp=fopen(fontname,"r"))==(FILE*)0)
  {
    fprintf(stderr,_("banner: failed to open %s (%s).\n"),fontname,strerror(errno));
    exit(2);
  }
  line=0;
  if (++line,fgets(ln,sizeof(ln),fp)==(char*)0)
  {
    fprintf(stderr,_("banner: unexpected end of font file.\n"));
    exit(2);
  }
  if (sscanf(ln,"%d %d",&this->scanLines,&this->hspace)!=2)
  {
    fprintf(stderr,_("banner: invalid scan line count or horizontal space.\n"));
    exit(2);
  }
  while (++line,fgets(ln,sizeof(ln),fp))
  {
    ch=*ln;
    for (fch=&this->character[ch]; *fch; fch=&((*fch)->next));
    if ((*fch=malloc(sizeof(struct FontCharacter)))==(struct FontCharacter*)0)
    {
      fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),sizeof(struct FontCharacter),strerror(errno));
      exit(2);
    }
    (*fch)->connectLeft=(*fch)->connectRight=-1;
    (*fch)->next=(struct FontCharacter*)0;
    sscanf(ln+1,"%d %c %d %c",&(*fch)->connectLeft,&(*fch)->connectLeftWith,&(*fch)->connectRight,&(*fch)->connectRightWith);
    if (((*fch)->lines=malloc(this->scanLines*sizeof(struct FontCharacterScanLine)))==(struct FontCharacterScanLine*)0)
    {
      fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),this->scanLines*sizeof(struct FontCharacterScanLine),strerror(errno));
      exit(2);
    }
    for (i=0; i<this->scanLines; ++i)
    {
      size_t begin,len;

      if (++line,fgets(ln,sizeof(ln),fp)==(char*)0)
      {
        fprintf(stderr,_("banner: unexpected end of font file after character '%c'.\n"),ch);
        exit(2);
      }
      len=strlen(ln);
      if (len && ln[len-1]=='\n') ln[--len]='\0';
      for (begin=0; ln[begin]==' '; ++begin,--len);
      if (ln[begin]=='\0')
      {
        len=strlen(ln);
        begin=0;
      }
      if (((*fch)->lines[i].line=malloc(len+1))==(char*)0)
      {
        fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),len+1,strerror(errno));
        exit(2);
      }
      (*fch)->lines[i].length=len;
      (*fch)->lines[i].begin=begin;
      strcpy((*fch)->lines[i].line,ln+begin);
    }
  }
  return this;
}
/*}}}*/
#if 0
static void dumpFont(struct Font *this) /*{{{*/
{
  int ch;

  printf("%d scan lines\n",this->scanLines);
  for (ch=0; ch<256; ++ch) if (this->character[ch])
  {
    struct FontCharacter *fch;

    for (fch=this->character[ch]; fch; fch=fch->next)
    {
      int i;

      printf("character %c",ch);
      if (fch->connectLeft>=0) printf(", connect from %d with %c",fch->connectLeft,fch->connectLeftWith);
      if (fch->connectRight>=0) printf(", connect to %d with %c",fch->connectRight,fch->connectRightWith);
      printf("\n");
      for (i=0; i<this->scanLines; ++i)
      {
        int j;

        for (j=0; j<fch->lines[i].begin; ++j) printf(" ");
        printf("%s\n",fch->lines[i].line);
      }
    }
  }
}
/*}}}*/
#endif
