/* #includes *//*{{{C}}}*//*{{{*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE 1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include "config.h"

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#include <sys/types.h>
#include <assert.h>
#include <errno.h>
#ifdef HAVE_GETTEXT
#include <libintl.h>
#define _(String) gettext(String)
#else
#define _(String) String
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <unistd.h>

#include "misc.h"
/*}}}*/

#ifdef BROKEN_REALLOC
/* myrealloc   -- ANSI conforming realloc() */ /*{{{*/
#undef realloc
void *myrealloc(void *p, size_t n)
{
  return (p==(void*)0 ? malloc(n) : realloc(p,n));
}
/*}}}*/
#endif
#ifndef HAVE_STRERROR
/* strerror    -- ANSI strerror */ /*{{{*/
extern int sys_nerr;
extern char *sys_errlist[];

char *strerror(int errno)
{
  assert(errno>=0);
  assert(errno<sys_nerr);
  return sys_errlist[errno];
}
/*}}}*/
#endif
