/* #includes */ /*{{{C}}}*//*{{{*/
#include "config.h"

#include <errno.h>
#ifdef HAVE_GETTEXT
#include <libintl.h>
#define _(String) gettext(String)
#else
#define _(String) String
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "font.h"
#include "misc.h"
#include "outputline.h"
/*}}}*/

struct OutputLine *OutputLine_new(int scanLines) /*{{{*/
{
  struct OutputLine *this;
  int i;

  if ((this=malloc(sizeof(struct OutputLine)))==(struct OutputLine*)0)
  {
    fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),sizeof(struct OutputLine),strerror(errno));
    exit(2);
  }
  this->scanLines=scanLines;
  this->empty=1;
  if ((this->lines=malloc(sizeof(struct ScanLine)*scanLines))==(struct ScanLine*)0)
  {
    fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),sizeof(struct ScanLine)*scanLines,strerror(errno));
    exit(2);
  }
  for (i=0; i<scanLines; ++i)
  {
    this->lines[i].line=(char*)0;
    this->lines[i].length=this->lines[i].capacity=0;
  }
  this->connectRight=-1;
  return this;
}
/*}}}*/
void OutputLine_printLineHorizontal(struct OutputLine *this) /*{{{*/
{
  int i;

  for (i=0; i<this->scanLines; ++i)
  {
    if (this->lines[i].line) printf("%s\n",this->lines[i].line);
    else printf("\n");
  }
}
/*}}}*/
void OutputLine_printLineVertical(struct OutputLine *this) /*{{{*/
{
  int i,j,more=1;

  for (j=0; more; ++j)
  {
    for (more=0,i=this->scanLines-1; i>=0; --i) if (j<this->lines[i].length) more=1;
    if (more)
    {
      for (i=this->scanLines-1; i>=0; --i)
      {
        putchar(j<this->lines[i].length ? this->lines[i].line[j] : ' ');
        putchar(j<this->lines[i].length ? this->lines[i].line[j] : ' ');
      }
      putchar('\n');
    }
  }
  putchar('\n');
}
/*}}}*/
void OutputLine_addChar(struct OutputLine *this, char ch, struct Font *font) /*{{{*/
{
  struct FontCharacter *fch=font->character[(unsigned int)((unsigned char)ch)];
  int connect,col=-32767,i;

  if (fch==(struct FontCharacter*)0) return;
  if (fch->connectLeft>=0 && this->connectRight>=0)
  {
    while (fch && (fch->connectLeft!=this->connectRight || fch->connectLeftWith!=this->connectRightWith)) fch=fch->next;
  }
  if (fch==(struct FontCharacter*)0)
  {
    fch=font->character[(unsigned int)((unsigned char)ch)];
  }
  for (i=0; i<this->scanLines; ++i) if (fch->lines[i].line[0])
  {
    int foo;

    if ((foo=this->lines[i].length-fch->lines[i].begin)>col) col=foo;
  }
  for (i=0; i<this->scanLines; ++i) if (fch->lines[i].line[0])
  {
    int spaces=col-this->lines[i].length+fch->lines[i].begin;
    int pad;

    if (!this->empty) spaces+=font->hspace;
    if ((this->lines[i].length+spaces+fch->lines[i].length+1)>=this->lines[i].capacity)
    {
      if ((this->lines[i].line=realloc(this->lines[i].line,this->lines[i].capacity+=spaces+fch->lines[i].length+1+64))==(char*)0)
      {
        fprintf(stderr,_("banner: failed to allocate %d bytes (%s)\n"),this->lines[i].capacity,strerror(errno));
        exit(2);
      }
    }
#if 0
    if (i==fch->connectLeft)
    {
      int j;

      for (j=0; j<font->hspace/2 && spaces>2; ++j,--spaces) this->lines[i].line[this->lines[i].length++]=this->connectRightWith;
    }
#endif
    pad=(i==this->connectRight && i==fch->connectLeft) ? this->connectRightWith : ' ';
    if (spaces>0)
    {
      memset(this->lines[i].line+this->lines[i].length,pad,spaces);
      this->lines[i].length+=spaces;
    }
    strcpy(this->lines[i].line+this->lines[i].length,fch->lines[i].line);
    this->lines[i].length+=fch->lines[i].length;
  }
  this->connectRight=fch->connectRight;
  this->connectRightWith=fch->connectRightWith;
  this->empty=0;
}
/*}}}*/
void OutputLine_erase(struct OutputLine *this) /*{{{*/
{
  int i;

  this->empty=1;
  for (i=0; i<this->scanLines; ++i) if (this->lines[i].capacity)
  {
    this->lines[i].line[0]='\0';
    this->lines[i].length=0;
  }
}
/*}}}*/
int OutputLine_isEmpty(struct OutputLine *this) /*{{{*/
{
  return this->empty;
}
/*}}}*/
