#ifndef OUTPUTLINE_H
#define OUTPUTLINE_H

#include "font.h"

struct OutputLine
{
  int scanLines;
  int empty;
  int connectRight;
  char connectRightWith;
  struct ScanLine
  {
    char *line;
    size_t length,capacity;
  } *lines;
};

struct OutputLine * OutputLine_new(int scanLines);
void OutputLine_addChar(struct OutputLine *this, char ch, struct Font *font);
void OutputLine_printLineHorizontal(struct OutputLine *this);
void OutputLine_printLineVertical(struct OutputLine *this);
void OutputLine_erase(struct OutputLine *this);
int OutputLine_isEmpty(struct OutputLine *this);

#endif
